''''''''''''''''''
'Annotation pages'
''''''''''''''''''
function Main as string
Dim Form as object
Dim Text as string
Dim i as integer
const Title = "Page Annotation"

  Form = ReadForm("Annpg.frm")
  'Form.SetStrValue("Text", "Page $N")
  if Form.ExecForm then
    Text = Form.GetStrValue("Text")
    for i = 1 to ActiveDocument.Count
      PageAnnotation(i, Text)
    next i
    Main = "Completed"
  else
    Main = "Cancelled"
  end if

end function

sub PageAnnotation(PNum as integer, Templ as string)
Dim i as integer
Dim ResStr, StrPart as string
Dim Page as object

  Page = ActiveDocument.Item(PNum)
  ResStr = ""
  i = 1
  while i <= Len(Templ)
    if Mid(Templ, i, 1) = "$" then
      i = i+1
      select case Ucase(Mid(Templ, i, 1))
        case "N"
          ResStr = ResStr + Page.GetName
        case "P"
          ResStr = ResStr + Str(PNum)
        case else
          ResStr = ResStr + Mid(Templ, i, 1)
      end select
    else
    	ResStr = ResStr + Mid(Templ, i, 1)
    end if
    i = i+1
  end while
  DrawTemplate(ResStr, PNum)
end sub

sub DrawTemplate(Templ as string, PNum as integer)
Dim pw, ph as integer
Dim CurPage, TextBox as object

  CurPage = ActiveDocument.Item(PNum)
  pw = CurPage.GetWidth
  ph = CurPage.GetHeight
  TextBox = CurPage.TextBoxes.AddEmpty
  TextBox.SetContent(Templ)
  TextBox.SetBound(pw - 23*Len(Templ)-200 , ph-120, 23*Len(Templ), 100)
  
end sub
